/**
* Script: clock.js
* Written by: Radnen
* Updated: 11/26/2010
**/

// Script originally created by WIP.

// Modified slightly by tunginobi to correctly show time
// after the hours, minutes and/or seconds have been
// changed or loaded.

// This is a function that will create a game clock object.
// Just use the function clock.getTime() and it will
// return an object with seconds, minutes and hours
// Note: You must start the clock before it will give
// the correct time

// Modified more by Radnen to make it work better when loading.
// Apparently, storing the array as a JSON string will not work
// this is becuase minutes of "06" != 6.

// Update: on second thought, it seems that Spheres file
// object does conversion for you. So that "06" == 6. On
// that regard I added save and load methods. But there
// is still an issue with the JSON string format. Arg!!!

function GameClock()
{
  this.started = 0;
  this.seconds = 0;
  this.minutes = 0;
  this.hours = 0;
}

// Example: var GameClock = new Clock();

GameClock.prototype.start = function()
{
  this.started = GetTime();
}

// Example: GameClock.start();

GameClock.prototype.reset = function()
{
	this.started = this.seconds = this.hours = this.minutes = 0;
}

// Example: GameClock.reset();

GameClock.prototype.setTime = function(a)
{
	this.seconds = a[2];
	this.minutes = a[1];
	this.hours = a[0];
}

// You must insert the array returned from get time. Best
// used when loading your game.
// Example: GameClock.setTime(OldClock.getTime(true));

GameClock.prototype.save = function(file)
{
	var tt = this.getTime(true);
	file.write("time_secs", tt[2]);
	file.write("time_mins", tt[1]);
	file.write("time_hours", tt[0]);
}

// Example: GameClock.save(new File("Clock.txt"));

GameClock.prototype.load = function(file)
{
	this.seconds = file.read("time_secs", 0);
	this.minutes = file.read("time_mins", 0);
	this.hours = file.read("time_hours", 0);
}

// Example: GameClock.load(new File("Clock.txt"));
// This can be used in lieu of loading manually
// and using GameClock.setTime();

// Notice that when File.read() is given a number it will
// as the API says, convert it to a number. Notice this
// does not happen if you load it as a string. Loading a
// string will break the script.


GameClock.prototype.getTime = function(a)
{
  var current = GetTime() - this.started;
  var secs = "";
  var mins = "";
  var hours = "";
  
  if (Math.floor((current)/1000 + this.seconds) % 60 < 10)
    secs += "0";
  secs += Math.floor((current)/1000 + this.seconds) % 60;
  
  if (Math.floor((current + this.seconds * 1000)/1000/60 + this.minutes) % 60 < 10)
    mins += "0";
  mins += Math.floor((current + this.seconds * 1000)/1000/60 + this.minutes) % 60;
  
  if (Math.floor((current + this.seconds * 1000 + this.minutes * 60 * 1000)/1000/60/60 + this.hours) % 60 < 10)
    hours += "0";
  hours += Math.floor((current + this.seconds * 1000 + this.minutes * 60 * 1000)/1000/60/60 + this.hours) % 60;
  
  if (a == true)
    return [hours, mins, secs];
  else
    return hours + ":" + mins + ":" + secs;
}

// Example:
// font.drawText(10, 10, clock.getTime());
//
// Every time you want to start keeping track of time,
// start the clock. If you are loading a game, you should
// load the time into the clock object. That way, it can keep
// correct time with a loaded game.
//
// clock.getTime(true) returns the time in an array (of numbers instead of strings)
// Example:
// var time = clock.getTime(true);
// font.drawText(10, 10, time[0]); // Hours
// font.drawText(10, 20, time[1]); // Minutes
// font.drawText(10, 30, time[2]); // Seconds
